/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModList;
import org.lwjgl.opengl.GL11;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.GunRenderingHandler;
import ttv.migami.jeg.client.screen.ButtonAlignment;
import ttv.migami.jeg.client.screen.widget.MiniButton;
import ttv.migami.jeg.client.util.RenderUtil;
import ttv.migami.jeg.common.container.AttachmentContainer;
import ttv.migami.jeg.common.container.slot.AttachmentSlot;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;

public class AttachmentScreen
extends AbstractContainerScreen<AttachmentContainer> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("jeg:textures/gui/attachments.png");
    private static final Component CONFIG_TOOLTIP = Component.m_237115_((String)"jeg.button.config.tooltip");
    private final Inventory playerInventory;
    private final Container weaponInventory;
    private boolean showHelp = true;
    private int windowZoom = 10;
    private int windowX;
    private int windowY;
    private float windowRotationX;
    private float windowRotationY;
    private boolean mouseGrabbed;
    private int mouseGrabbedButton;
    private int mouseClickedX;
    private int mouseClickedY;

    public AttachmentScreen(AttachmentContainer screenContainer, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, playerInventory, titleIn);
        this.playerInventory = playerInventory;
        this.weaponInventory = screenContainer.getWeaponInventory();
        this.f_97727_ = 184;
    }

    protected void m_7856_() {
        super.m_7856_();
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    int titleWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)this.f_96539_);
                    button.f_93620_ = this.f_97735_ + titleWidth + 8 + 3 + i * 13;
                    break;
                }
                case RIGHT: {
                    button.f_93620_ = this.f_97735_ + this.f_97726_ - 7 - 10 - (buttons.size() - 1 - i) * 13;
                }
            }
            button.f_93621_ = this.f_97736_ + 5;
            this.m_142416_((GuiEventListener)button);
        }
    }

    private List<MiniButton> gatherButtons() {
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            buttons.add(new MiniButton(0, 0, 192, 0, GUI_TEXTURES, onPress -> this.openConfigScreen(), (button, matrixStack, mouseX, mouseY) -> this.m_96602_(matrixStack, CONFIG_TOOLTIP, mouseX, mouseY)));
        }
        return buttons;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && !(this.f_96541_.f_91074_.m_21205_().m_41720_() instanceof GunItem)) {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            AttachmentSlot slot;
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, startX + 7, startY + 16 + i * 18, 18, 18)) continue;
            IAttachment.Type type = IAttachment.Type.values()[i];
            if (!((AttachmentContainer)this.f_97732_).m_38853_(i).m_6659_()) {
                this.m_96597_(poseStack, Arrays.asList(Component.m_237115_((String)("slot.jeg.attachment." + type.getTranslationKey())), Component.m_237115_((String)"slot.jeg.attachment.not_applicable")), mouseX, mouseY);
                continue;
            }
            Slot slot2 = ((AttachmentContainer)this.f_97732_).m_38853_(i);
            if (slot2 instanceof AttachmentSlot && (slot = (AttachmentSlot)slot2).m_7993_().m_41619_() && !this.isCompatible(((AttachmentContainer)this.f_97732_).m_142621_(), slot)) {
                this.m_96597_(poseStack, Arrays.asList(Component.m_237115_((String)"slot.jeg.attachment.incompatible").m_130940_(ChatFormatting.YELLOW)), mouseX, mouseY);
                continue;
            }
            if (!this.weaponInventory.m_8020_(i).m_41619_()) continue;
            this.m_96597_(poseStack, Collections.singletonList(Component.m_237115_((String)("slot.jeg.attachment." + type.getTranslationKey()))), mouseX, mouseY);
        }
        this.m_6702_().forEach(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).m_198029_()) {
                button.m_7428_(poseStack, mouseX, mouseY);
            }
        });
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.playerInventory.m_5446_(), (float)this.f_97730_, (float)this.f_97731_ + 19.0f, 0x404040);
        GL11.glEnable((int)3089);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        RenderUtil.scissor(left + 26, top + 17, 124, 70);
        PoseStack stack = RenderSystem.m_157191_();
        stack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.m_85837_(96.0, 50.0, 100.0);
        stack.m_85837_((double)(this.windowX + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseX - this.mouseClickedX : 0)), 0.0, 0.0);
        stack.m_85837_(0.0, (double)(this.windowY + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseY - this.mouseClickedY : 0)), 0.0);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(this.windowRotationY - (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseY - this.mouseClickedY : 0)));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(this.windowRotationX + (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseX - this.mouseClickedX : 0)));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(150.0f));
        stack.m_85841_((float)this.windowZoom / 10.0f, (float)this.windowZoom / 10.0f, (float)this.windowZoom / 10.0f);
        stack.m_85841_(90.0f, -90.0f, 90.0f);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(5.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        GunRenderingHandler.get().renderWeapon((LivingEntity)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_21205_(), ItemTransforms.TransformType.GROUND, new PoseStack(), (MultiBufferSource)buffer, 0xF000F0, 0.0f);
        buffer.m_109911_();
        stack.m_85849_();
        RenderSystem.m_157182_();
        GL11.glDisable((int)3089);
        if (this.showHelp) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            minecraft.f_91062_.m_92883_(poseStack, I18n.m_118938_((String)"container.jeg.attachments.window_help", (Object[])new Object[0]), 56.0f, 38.0f, 0xFFFFFF);
            poseStack.m_85849_();
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURES);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, left, top, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            int x = i < 4 ? 8 : 152;
            int y = 17 + i % 4 * 18;
            if (!this.canPlaceAttachmentInSlot(((AttachmentContainer)this.f_97732_).m_142621_(), ((AttachmentContainer)this.f_97732_).m_38853_(i))) {
                this.m_93228_(poseStack, left + x, top + y, 176, 0, 16, 16);
                continue;
            }
            if (!this.weaponInventory.m_8020_(i).m_41619_()) continue;
            this.m_93228_(poseStack, left + x, top + y, 176, 16 + i % 5 * 16, 16, 16);
        }
    }

    private boolean canPlaceAttachmentInSlot(ItemStack stack, Slot slot) {
        if (!slot.m_6659_()) {
            return false;
        }
        if (!slot.equals(this.getSlotUnderMouse())) {
            return true;
        }
        if (!slot.m_7993_().m_41619_()) {
            return true;
        }
        if (stack.m_41720_() instanceof SwordItem) {
            return true;
        }
        if (!(slot instanceof AttachmentSlot)) {
            return true;
        }
        AttachmentSlot s = (AttachmentSlot)slot;
        Item item = stack.m_41720_();
        if (!(item instanceof IAttachment)) {
            return true;
        }
        IAttachment a = (IAttachment)item;
        if (!s.getType().equals((Object)a.getType())) {
            return true;
        }
        return s.m_5857_(stack);
    }

    private boolean isCompatible(ItemStack stack, AttachmentSlot slot) {
        if (stack.m_41619_()) {
            return true;
        }
        if (stack.m_41720_() instanceof SwordItem) {
            return true;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IAttachment)) {
            return false;
        }
        IAttachment attachment = (IAttachment)item;
        if (!attachment.getType().equals((Object)slot.getType())) {
            return true;
        }
        if (!attachment.canAttachTo(stack)) {
            return false;
        }
        return slot.m_5857_(stack);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        if (RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 124, 70)) {
            if (scroll < 0.0 && this.windowZoom > 0) {
                this.showHelp = false;
                --this.windowZoom;
            } else if (scroll > 0.0) {
                this.showHelp = false;
                ++this.windowZoom;
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        if (RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 124, 70) && !this.mouseGrabbed && (button == 0 || button == 1)) {
            this.mouseGrabbed = true;
            this.mouseGrabbedButton = button == 1 ? 1 : 0;
            this.mouseClickedX = (int)mouseX;
            this.mouseClickedY = (int)mouseY;
            this.showHelp = false;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.mouseGrabbed) {
            if (this.mouseGrabbedButton == 0 && button == 0) {
                this.mouseGrabbed = false;
                this.windowX = (int)((double)this.windowX + (mouseX - (double)this.mouseClickedX - 1.0));
                this.windowY = (int)((double)this.windowY + (mouseY - (double)this.mouseClickedY));
            } else if (this.mouseGrabbedButton == 1 && button == 1) {
                this.mouseGrabbed = false;
                this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
                this.windowRotationY = (float)((double)this.windowRotationY - (mouseY - (double)this.mouseClickedY));
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void openConfigScreen() {
        ModList.get().getModContainerById("jeg").ifPresent(container -> {
            Screen screen = container.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).map(function -> (Screen)function.screenFunction().apply(this.f_96541_, null)).orElse(null);
            if (screen != null) {
                this.f_96541_.m_91152_(screen);
            } else if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                MutableComponent modName = Component.m_237113_((String)"Configured");
                modName.m_6270_(modName.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131162_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"jeg.chat.open_curseforge_page"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured")));
                MutableComponent message = Component.m_237110_((String)"jeg.chat.install_configured", (Object[])new Object[]{modName});
                this.f_96541_.f_91074_.m_5661_((Component)message, false);
            }
        });
    }
}

